//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[ChatMessage](-chat-message.md)

# ChatMessage

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [ChatMessage](-chat-message.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, message: [Message](../ai.botstacks.sdk.state/-message/index.md), shape: [CornerBasedShape](https://developer.android.com/reference/kotlin/androidx/compose/foundation/shape/CornerBasedShape.html) = shapes.medium, showAvatar: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, showTimestamp: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, onPressUser: ([User](../ai.botstacks.sdk.state/-user/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), onLongPress: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), onClick: ([MessageAttachment](../ai.botstacks.sdk.state/-message-attachment/index.md)?) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null)

ChatMessage

Renders the contents of a given [Message](../ai.botstacks.sdk.state/-message/index.md) from a [ai.botstacks.sdk.state.Chat](../ai.botstacks.sdk.state/-chat/index.md). This is used by [MessageList](-message-list.md) to form the contents of a conversational chat, by properly aligning messages to left or right depending on sender (left aligned for incoming and right aligned for outgoing).

#### Parameters

common

| | |
|---|---|
| modifier | The modifier to apply to this message. |
| message | The message to display. |
| shape | corner-based shaped to render the &quot;bubble&quot; in. This defaults to [ai.botstacks.sdk.ui.theme.ShapeDefinitions.medium](../ai.botstacks.sdk.ui.theme/-shape-definitions/medium.md). |
| showAvatar | Whether to show the associated user's avatar along with this message. |
| showTimestamp | Whether to show the timestamp this message was sent or received. |
| onPressUser | callback for when a user's avatar (when visible) is clicked. |
| onLongPress | callback for when a message &quot;bubble&quot; is clicked. |
| onClick | callback for when an attachment is clicked. This is utlized by [MessageList](-message-list.md) to show images for full screen viewing. |
